function difference = GMM_res(x, y, moments, W, N_variables, N_ll)
% This function computes the output to be minimized in the GMM procedure


if nargin<4
    W = eye(length(moments));
end


% Moving estimated parameters into bounds

x(1) = exp(x(1))/(1+exp(x(1)));        % epsilon (limiting epsilon<xi_o)
lambda(1:2) = (1 - 2 * exp(x(2:3))./(1+exp(x(2:3)))); % rhos eigenvalues
x(2) = lambda(1) + lambda(2);                       % rho_d1
x(3) = - lambda(1) * lambda(2);                     % rho_d2
x(4:5) = 10^(-7) + exp(x(4:5));                   % var_u var_d
x(4:5) = min(x(4:5), 5);
x(6) = 0.6+0.4*exp(x(6))/(1+exp(x(6)));        % production share of OPEC non-cheaters out of total OPEC (lower limit set to 0.6 to meet BK conditions)

parameters = [y,x];

try
    model_moments = Model_Moments(parameters, N_variables, N_ll);
    M = (moments - model_moments)';

    difference = M' * W * M;
    disp(['Current Difference = ' num2str(difference)])
catch e
    difference = nan;
    disp(['Dynare error in parameterization'])
    disp(e.message);
end